<?php

class ispmanager_reselling extends HostingModule {

	protected $modname = 'ispmanager reselling';
	protected $version = '1.2.0';
	protected $description = 'ispmanager reselling module';

	protected $options = [
		'product_id' => [
			'name' => 'Product ID',
			'value' => false,
			'type' => 'loadable',
			'default' => 'getPlans',
		],
	];

	protected $serverFields = [
		'hostname' => true,
		'ip' => false,
		'maxaccounts' => false,
		'status_url' => false,
		'username' => true,
		'password' => true,
		'hash' => false,
		'ssl' => false,
		'nameservers' => false,
	];

	protected $details = [
		'licid' => [
			'name' => 'License ID',
			'value' => false,
			'type' => 'input',
			'default' => false,
		],
	];

	protected $lang = [
		'english' => [
			'ispmanager_license_details' => 'License details',
			'ispmanager_license_id' => 'License ID',
			'ispmanager_license_name' => 'License name',
			'ispmanager_license_ip' => 'License IP',
			'ispmanager_license_key' => 'License key',
			'ispmanager_status' => 'Status',
			'ispmanager_status_unknown' => 'Unknown',
			'ispmanager_status_ordered' => 'Ordered',
			'ispmanager_status_active' => 'Active',
			'ispmanager_status_suspended' => 'Suspended',
			'ispmanager_status_deleted' => 'Deleted',
			'ispmanager_status_processing' => 'Processing',
			'ispmanager_createdate' => 'Creation date',
			'ispmanager_expiredate' => 'Expiration date',
			'ispmanager_generate_new_key' => 'Generate a new key',
			'ispmanager_newkey_generated' => 'New key generated successfully',
		],
		'russian' => [
			'ispmanager_license_details' => 'Информация о лицензии',
			'ispmanager_license_id' => 'ИД лицензии',
			'ispmanager_license_name' => 'Название лицензии',
			'ispmanager_license_ip' => 'IP-адрес лицензии',
			'ispmanager_license_key' => 'Ключ лицензии',
			'ispmanager_status' => 'Статус',
			'ispmanager_status_unknown' => 'Неизвестный',
			'ispmanager_status_ordered' => 'Заказан',
			'ispmanager_status_active' => 'Активен',
			'ispmanager_status_suspended' => 'Остановлен',
			'ispmanager_status_deleted' => 'Удален',
			'ispmanager_status_processing' => 'Обрабатывается',
			'ispmanager_createdate' => 'Дата создания',
			'ispmanager_expiredate' => 'Действует до',
			'ispmanager_generate_new_key' => 'Сгенерировать новый ключ',
			'ispmanager_newkey_generated' => 'Новый ключ успешно сгенерирован',
		],
	];

	private $server_username;
	private $server_password;
	private $server_hostname;

	public function connect($connect) {
		$this->server_username = $connect['username'];
		$this->server_password = $connect['password'];
		$this->server_hostname = $connect['host'];
	}

	public function testConnection() {
		try {
			$this->call('dashboard');
			return true;
		} catch (\Throwable $th) {
			$this->addError($th->getMessage());
			return false;
		}
	}

	public function Create() {
		$pricelist = $this->options['product_id']['value'];
		$ip = $this->account_config['ip']['value'] ?? '';
		$licname = $this->account_config['licname']['value'] ?? '';

		if (!$pricelist && !empty($this->account_config['pricelist']['variable_id'])) $pricelist = $this->account_config['pricelist']['variable_id'];

		if (!empty($this->parent_account['ip'])) {
			$ip = $this->parent_account['ip'];
		} elseif (!empty($this->account_details['parent_id'])) {
			$api = new ApiWrapper();
			for ($i = 0; $i < 20; $i++) {
				sleep(30);
				$parent_info = $api->getAccountDetails(['id' => $this->account_details['parent_id']]);
				if (empty($parent_info['details']['ip'])) continue;
				$this->parent_account = $parent_info['details'];
				$ip = $parent_info['details']['ip'];
				break;
			}
		}

		if (!empty($this->parent_account['username'])) $licname = $this->parent_account['username'];

		$this->changeAccountConfig([
			'ip' => $ip,
			'licname' => $licname,
		]);

		if ($pricelist == 55235 || $pricelist == 55239) {
			$period = -100;
		} else {
			$billingcycle = $this->account_details['billingcycle'];
			if ($billingcycle == 'Triennially') {
				$period = 36;
			} else if ($billingcycle == 'Biennially') {
				$period = 24;
			} else if ($billingcycle == 'Annually') {
				$period = 12;
			} else if ($billingcycle == 'Semi-Annually') {
				$period = 6;
			} else if ($billingcycle == 'Quarterly') {
				$period = 3;
			} else {
				$period = 1;
			}
		}

		$order_params = array(
			'pricelist' => $pricelist,
			'period' => $period,
			'ip' => $ip,
			'licname' => $licname,
			'sok' => 'ok',
			'skipbasket' => 'on',
			'remoteid' => $this->account_details['id'],
			'clicked_button' => 'finish',
			'autoprolong' => 'null',
		);

		try {
			$response = $this->call('soft.order.param', $order_params);
			$this->details['licid']['value'] = $response['id']['v'];
			for ($i = 0; $i < 60; $i++) { 
				$details = $this->call('soft.edit', ['elid' => $response['id']['v'], 'out' => 'JSONdata']);
				if (!empty($details['lickey'])) {
					$this->changeAccountConfig([
						'lickey' => $details['lickey'],
					]);
					break;
				}
				sleep(5);
			}
			return true;
		} catch (\Throwable $th) {
			$this->addError($th->getMessage());
			return false;
		}
	}

	public function Renewal() {
		$billingcycle = $this->account_details['billingcycle'];
		if ($billingcycle == 'Triennially') {
			$period = 36;
		} else if ($billingcycle == 'Biennially') {
			$period = 24;
		} else if ($billingcycle == 'Annually') {
			$period = 12;
		} else if ($billingcycle == 'Semi-Annually') {
			$period = 6;
		} else if ($billingcycle == 'Quarterly') {
			$period = 3;
		} else {
			$period = 1;
		}

		try {
			if (empty($this->details['licid']['value'])) throw new Exception('Empty license id');
			$response = $this->call('service.prolong', [
				'elid' => $this->details['licid']['value'],
				'period' => $period,
				'sok' => 'ok',
				'out' => 'sjson',
			]);
			$expire_date = $response['doc']['newexpiredate']['$'];
			$api = new ApiWrapper();
			$api->editAccountDetails([
				'id' => $this->account_details['id'],
				'next_due' => $expire_date,
				'expires' => $expire_date,
			]);
			return true;
		} catch (\Throwable $th) {
			$this->addError($th->getMessage());
			return false;
		}
	}

	public function Terminate() {
		try {
			if (empty($this->details['licid']['value'])) throw new Exception('Empty license id');
			$response = $this->call('soft.delete', [
				'elid' => $this->details['licid']['value'],
				'sok' => 'ok',
			]);
			return true;
		} catch (\Throwable $th) {
			$this->addError($th->getMessage());
			return false;
		}
	}

	public function changeFormsFields($account_config) {
		if (empty($account_config)) return true;
		if ((!empty($account_config['ip']) && $account_config['ip']['value'] != $this->account_config['ip']['value']) || (!empty($account_config['ip']) && $account_config['ip']['value'] != $this->account_config['ip']['value'])) {
			try {
				if (empty($this->details['licid']['value'])) throw new Exception('Empty license id');
				$this->call('soft.edit', [
					'elid' => $this->details['licid']['value'],
					'out' => 'bjson',
					'ip' => $account_config['ip']['value'] ?? '',
					'licname' => $account_config['licname']['value'] ?? '',
					'sok' => 'ok',
				]);
			} catch (\Throwable $th) {
				$this->addError($th->getMessage());
				return false;
			}
		}
		if (!empty($account_config['pricelist']) && $account_config['pricelist']['variable_id'] != $this->account_config['pricelist']['variable_id']) {
			$this->setAccountConfig(array_merge($this->account_config, $account_config));
			return $this->ChangePackage();
		}
		return true;
	}

	public function ChangePackage() {
		$pricelist = $this->options['product_id']['value'];
		if (!$pricelist && !empty($this->account_config['pricelist']['variable_id'])) $pricelist = $this->account_config['pricelist']['variable_id'];

		try {
			if (empty($this->details['licid']['value'])) throw new Exception('Empty license id');
			$this->call('service.changepricelist', [
				'elid' => $this->details['licid']['value'],
				'pricelist' => $pricelist,
				'sok' => 'ok',
			]);
			return true;
		} catch (\Throwable $th) {
			$this->addError($th->getMessage());
			return false;
		}
	}

	public function getSynchInfo() {
		try {
			if (empty($this->details['licid']['value'])) throw new Exception('Empty license id');
			$details = $this->call('soft.edit', ['elid' => $this->details['licid']['value'], 'out' => 'JSONdata']);
			$this->changeAccountConfig([
				'ip' => $details['ip'] ?? '',
				'licname' => $details['licname'] ?? '',
				'lickey' => $details['lickey'] ?? '',
			]);
			return [
				'user' => 1,
			];
		} catch (\Throwable $th) {
			return false;
		}
	}

	public function getPlans() {
		$out = [
			['', 'Use field'],
		];
		if (strpos($this->server_hostname, 'my.') === 0) {
			$out[] = ['55235', 'Ispmanager 6 trial'];
			$out[] = ['55231', 'Ispmanager 6 lite'];
			$out[] = ['55232', 'Ispmanager 6 pro'];
			$out[] = ['55233', 'Ispmanager 6 host'];
		} else {
			$out[] = ['55239', 'Ispmanager 6 trial'];
			$out[] = ['55227', 'Ispmanager 6 lite'];
			$out[] = ['55228', 'Ispmanager 6 pro'];
			$out[] = ['55229', 'Ispmanager 6 host'];
		}
		return $out;
	}

	public function call(string $func, array $params = []) {
		$params['func'] = $func;
		if (!isset($params['out'])) $params['out'] = 'bjson';
		if (!isset($params['lang'])) $params['lang'] = 'en';
		$params['authinfo'] = $this->server_username . ':' . $this->server_password;
		$ch = curl_init('https://' . $this->server_hostname . '/billmgr');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));

		$response = curl_exec($ch);
		if (curl_errno($ch)) throw new Exception(curl_error($ch));

		$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		if (empty($response) || $code != 200) throw new Exception('Response code ' . $code);

		$response = json_decode($response, true);
		if (isset($response['doc'])) $response = $response['doc'];
		if (!empty($response['error']['msg'])) throw new Exception($response['error']['msg']['$'] ?? $response['error']['msg']);

		return $response;
	}

	public function changeAccountConfig(array $values) {
		if (empty($values)) return true;
		foreach ($values as $key => $value) {
			if (!isset($this->account_config[$key])) continue;
			$this->account_config[$key]['value'] = $value;
		}
		return $this->saveAccountConfig();
	}
}
