<?php

class widget_ispmanager_reselling_details extends HostingWidget {

	protected $description = 'Widget shows ispmanager license details';
	protected $widgetfullname = 'License details';

	public function clientFunction(&$module) {
		$account_details = $module->getDetails();
		$alert = null;
		if (!empty($_POST['action'])) {
			$lang = (!empty($_POST['language']) ? substr($_POST['language'], 0, 2) : 'en');
			if (!in_array($lang, ['ru', 'en'])) $lang = 'en';
			if ($_POST['action'] === 'save') {
				$licname = $_POST['licname'] ?? '';
				$ip = $_POST['ip'] ?? '';
				try {
					$module->call('soft.edit', [
						'elid' => $account_details['licid']['value'],
						'out' => 'bjson',
						'ip' => $ip,
						'licname' => $licname,
						'sok' => 'ok',
						'lang' => $lang,
					]);
					$module->changeAccountConfig([
						'ip' => $ip,
						'licname' => $licname,
					]);
					$alert = [
						'type' => 'success',
						'message' => _t('success_changes_save'),
					];
				} catch (\Throwable $th) {
					$alert = [
						'type' => 'danger',
						'message' => $th->getMessage(),
					];
				}
			} elseif ($_POST['action'] === 'newkey') {
				try {
					$module->call('soft.edit', [
						'elid' => $account_details['licid']['value'],
						'clicked_button' => 'newkey',
						'sok' => 'ok',
						'lang' => $lang,
					]);
					$alert = [
						'type' => 'success',
						'message' => _t('ispmanager_newkey_generated'),
					];
				} catch (\Throwable $th) {
					$alert = [
						'type' => 'danger',
						'message' => $th->getMessage(),
					];
				}
			}
		}
		$details = [];
		if (!empty($account_details['licid']['value'])) {
			try {
				$details = $module->call('soft.edit', ['elid' => $account_details['licid']['value'], 'out' => 'JSONdata']);
				$statuses = ['unknown', 'ordered', 'active', 'suspended', 'deleted', 'processing'];
				$details['status'] = _t('ispmanager_status_' . ($statuses[$details['status']] ?? 'unknown'));
			} catch (\Throwable $th) {
				$alert = [
					'type' => 'danger',
					'message' => $th->getMessage(),
				];
			}
		}
		return [
			'details.tpl',
			[
				'alert' => $alert,
				'details' => $details,
			],
		];
	}
}
